using System;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));

            pdf.SetImportFlags(TImportFlags.ifImportAll | TImportFlags.ifImportAsPage); // Import anything and avoid the conversion of pages to templates
            pdf.SetImportFlags2(TImportFlags2.if2UseProxy);                             // This flag reduces the memory usage.

            if (pdf.OpenImportFile(Path.GetFullPath("../../../../license.pdf"), TPwdType.ptOpen, null) < 0)
            {
               pdf = null;
               return;
            }

            // Very important: This property makes sure that the open import file will not be closed when CloseFile() is called.
            pdf.SetUseGlobalImpFiles(true);

            if (!Directory.Exists("out"))
               Directory.CreateDirectory("out");

            int i, count = pdf.GetInPageCount();
            for (i = 1; i <= count; i++)
            {
               pdf.CreateNewPDF(String.Format("out/{0:0000}.pdf", i));
                  pdf.Append();
                     pdf.ImportPageEx(i, 1.0, 1.0);
                  pdf.EndPage();
               pdf.CloseFile();
            }
	         // You should never forget to set the property back to false when finish.
	         // In this example it makes no difference but if the PDF instance is used
	         // to create or import other PDF files then make sure that the parser instance
	         // can be deleted.
            pdf.SetUseGlobalImpFiles(false);

            // Open the output directory
            System.Diagnostics.Process p = new System.Diagnostics.Process();
            p.StartInfo.FileName = Path.GetFullPath("out");
            p.Start();

            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
